WITH Text_IO;
WITH My_Int_IO;
PACKAGE BODY Screen IS

-- Procedures for drawing pictures on ANSI Terminal Screen
-- These procedures will work correctly only if the actual
-- terminal is ANSI compatible. ANSI.SYS on a DOS machine
-- will suffice.

-- Michael B. Feldman, The George Washington University


  PROCEDURE Beep IS
  BEGIN
    Text_IO.Put (Item => ASCII.BEL);
  END Beep;

  PROCEDURE ClearScreen IS
  BEGIN
    Text_IO.Put (Item => ASCII.ESC);
    Text_IO.Put (Item => "[2J");
  END ClearScreen;

  PROCEDURE MoveCursor (To: IN Position) IS
  BEGIN                                                
    Text_IO.New_Line;
    Text_IO.Put (Item => ASCII.ESC);
    Text_IO.Put ("[");
    My_Int_IO.Put (Item => To.Row, Width => 1);
    Text_IO.Put (Item => ';');
    My_Int_IO.Put (Item => To.Column, Width => 1);
    Text_IO.Put (Item => 'f');
  END MoveCursor;  

END Screen;
